import torch

from abc import abstractmethod

torch.set_printoptions(precision=8)


class ModelRunner:

    def __init__(self, params):
        self.vector_size = params['vector_size']
        if self.vector_size is None:
            raise ValueError('Vector size must be specified')

    @abstractmethod
    def run(self, iterations, model_name, save_plot, plots_directory):
        raise NotImplementedError()
